//g++ circle.cpp pcxf.o -lSDL
//test
#include <time.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include "SDL/SDL.h"
#include "SDL/SDL_opengl.h"
#include <pcxf.h>

//__________________________________function prototypes________________________________________________
//void detect(void);
void draw(void);
void quit(void);
void input(char *key, int updown);
void showfps(void);

void glEnable2D(void);
void glDisable2D(void);
void pixely(int x, int y, int c);
//________________________________________________global variables____________________________________________
long int frames = 0;
long int seconds = 0;
int fps = 0;

SDL_Surface *screen;

//_________________________________________________constants___________________________________________________
#define SCREEN_WIDTH 1024
#define SCREEN_HEIGHT 758
#define SCREEN_BPP 16
#define SCREEN_bPP SCREEN_BPP / 8

//make space for image:
pcx robot;
pcx robot2;
//______________________________________________________main______________________________________________________
int main(int argc, char* args[]) {   
try {

	//Start SDL 
	SDL_Init(SDL_INIT_EVERYTHING); //SDL_INIT_VIDEO   
	//SDL_ShowCursor(0);

	//Set up the screen	
   SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
   screen = SDL_SetVideoMode(SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP, SDL_OPENGL | SDL_DOUBLEBUF | SDL_HWPALETTE); //SDL_SWSURFACE //SDL_DOUBLEBUF SDL_HWSURFACE

	setScreenGL(pixely, SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP);

	loadFonts(); //load fonts.

///	SDL_SetPalette(screen, SDL_LOGPAL|SDL_PHYSPAL, (SDL_Color *) getPalette((char *) "palette.gpl"), 0, 256);

   glDisable(GL_DEPTH_TEST); //i added this one.
   glEnable2D(); //make 2d drawing work.

	//load images:
	pcxStore32((char *) "robot256.pcx", &robot);

	//draw to image:
	pcxRestore32(&robot, 90, &robot2);
   //int c = colour(255, 0, 0);
	//drawOn(&robot2);
	//line(0, 0, 100, 100, c);

	setScreen(screen->pixels, SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP);	

   //SDL event loop:
	SDL_Event event;   
	int running = 1;
	SDL_KeyboardEvent *key;

   while(running) {
		while(SDL_PollEvent(&event)) {
		//if (SDL_WaitEvent(&event)) {
			switch(event.type){
				case SDL_KEYDOWN:
				case SDL_KEYUP:
					key = &event.key;
					input((char *) SDL_GetKeyName(key->keysym.sym), (int) key->type);
					if (strcmp(SDL_GetKeyName(key->keysym.sym), "escape") == 0) {
						running = 0;
					}
					break;
			} 
		}
		if(SDL_MUSTLOCK(screen)) { SDL_LockSurface(screen); }
		//memset(screen->pixels, 0, SCREEN_WIDTH * SCREEN_HEIGHT * SCREEN_bPP);
      glClear(GL_COLOR_BUFFER_BIT);
      draw();
		showfps();
		if (SDL_MUSTLOCK(screen)) { SDL_UnlockSurface(screen); }
      SDL_GL_SwapBuffers();
	}

} catch(...) {
	quit();
	return 0;
}
	quit();
	return 0;
}

void showfps(void) {

   //calculate, display fps:
   if (clock() > CLOCKS_PER_SEC) {
	   if (clock() / CLOCKS_PER_SEC > seconds) {
         fps = frames;
         seconds++;
         frames = 0;
	   }   
   }
	frames++;
   int white = colour(255, 255, 255);
   writeInt(1, 1, (int) fps, white);
   writeString(20, 1, (char *) "fps", white);
}

//______________________________________________________________________________________________________________

void quit(void) {
   SDL_FreeSurface(screen); //Free the surface.
   SDL_Quit();
   glDisable2D();
   glEnable(GL_DEPTH_TEST);
   unloadFonts();  
}

int off = 0;

void draw(void) {
/*	
	for (int i = 0; i < 255 ; i++ ) {
		*((char *) screen->pixels + i) = (char) i;
	}

	for (int i = 0; i < 65535 ; i++ ) {
		*((short *) screen->pixels + 100000 + i) = (short) i;
	}

	char c = 0; char  d = 0; char e = 0; 
	for (int i = 0; i < 200000 ; i++ ) {
//		*((bit24 *) screen->pixels + 500000 + (1024 * 200) + i) = colour(c, d, e);
		*((short *) screen->pixels + 500000 + off + i) = colour(c, d, e);
		*((long *) screen->pixels + 500000 + off + i) = colour(c, d, e);
		c += 3;
		d -= 2;
		e += 5;
	}
	//off += 1024;

	for (int i = 0; i < 800 ;i++ ) {
		pixel(i, 900, colour(i, 0, 0));
	}

	for (int i = 0; i < 800 ;i++ ) {
		pixel(i, 950, colour(255, 255, 255));
	}

	//long col = RGB32BIT(255, 0, 255, 0);
	//int col2 = RGB24BIT(255, 255, 0);
	int col = colour(200, 0, 0);
	//char col = 200;
	//printf("%ld\n", col);
	line(200, 200, 300, 300, col);
	memset((short *) screen->pixels + 10000, col, 100000);
//	memset((bit24 *) screen->pixels + 100000, col, 100000);

	for (int i = 0; i < 20000 ; i++ ) {
		*((short *) screen->pixels + 300000 + i) = col;
	}

	//get mouse position:
	int mousex; int mousey;
	char buttons = SDL_GetMouseState(&mousex, &mousey);

	//display circle:
	double r = 50;
	int x = 0;
	int y = 1;
	while (x < y) {
		y = sqrt(pow(r, 2) - (pow(x, 2)));
		pixel(mousex + x, mousey - y, colour(0, 80 + x, 0)); // + 0.5;
		x++;
	}
*/

   rectangle(140, 140, 500, 180, colour(255, 255, 0));

//	for (int i = 0; i < 255 ; i++ ) {
//		*((char *) screen->pixels + i + 11600) = (char) i;
//	}

   pcxDisplay32(500, 300, &robot, NULL);
	pcxDisplay32(100, 500, &robot2, NULL);

   writeString(200, 1, (char *) "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ~!%$%!@(@$*()#%_(&lksdjfsdkjf&dfd", NULL);
   writeString(200, 100, (char *) "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ~!@#$%^&*)(-=_+|[]{}';:,.<>/?\"\\", colour(255, 0, 0));
   writeDouble(300, 10, 41.99, colour(255, 255, 0));
}


void input(char *key, int updown) {

}


//______________________________________opengl stuff________________________________
void pixely(int x, int y, int c) {
   #if SCREEN_BPP == 8
      GLubyte *u = (GLubyte *) &c;
      glColor3ub(u[0], u[0], u[0]); //grayscale palette.
      //glIndexub(c);
      //glIndexi(c);
   #elif SCREEN_BPP == 16
      glColor3ub( ((c & 0xF800) >> 11) << 3, ((c & 0x07E0) >> 5) << 2, (c & 0x001F) << 3 );
   #elif SCREEN_BPP == 24
      GLubyte *u = (GLubyte *) &c;
      glColor3ub(u[2], u[1], u[0]);
   #elif SCREEN_BPP == 32
      GLubyte *u = (GLubyte *) &c;
      glColor4ub(u[2], u[1], u[0], u[4]);
   #endif

   glBegin(GL_POINTS);
   glVertex2i(x, SCREEN_HEIGHT - y);
   glEnd();
}

void glEnable2D() {
   int vPort[4];

   glGetIntegerv(GL_VIEWPORT, vPort);

   glMatrixMode(GL_PROJECTION);
   glPushMatrix();
   glLoadIdentity();

   glOrtho(0, vPort[2], 0, vPort[3], -1, 1);
   glMatrixMode(GL_MODELVIEW);
   glPushMatrix();
   glLoadIdentity();
}

void glDisable2D() {
   glMatrixMode(GL_PROJECTION);
   glPopMatrix();   
   glMatrixMode(GL_MODELVIEW);
   glPopMatrix();
}
